<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('late_forms', function (Blueprint $table) {
            $table->unsignedBigInteger('late_procedure_id');
            $table->foreign('late_procedure_id')->references('id')->on('late_procedures')->onDelete('cascade');
            
            $table->unsignedBigInteger('late_form_id');
            $table->foreign('late_form_id')->references('id')->on('namazeg')->onDelete('cascade');
            
            // $table->primary(['late_procedure_id', 'late_form_id']);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('late_forms');
    }
};
