<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('absence_forms', function (Blueprint $table) {
            $table->unsignedBigInteger('absence_procedure_id');
            $table->foreign('absence_procedure_id')->references('id')->on('absence_procedures')->onDelete('cascade');
            
            $table->unsignedBigInteger('absence_form_id');
            $table->foreign('absence_form_id')->references('id')->on('namazeg')->onDelete('cascade');
            
            // $table->primary(['absence_procedure_id', 'absence_form_id']);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('absence_forms');
    }
};
