<?php

namespace App\Traits;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Auth;
use Tymon\JWTAuth\Facades\JWTAuth;

trait LogsActivity
{

    public function AdminlogActivity(string $model, string $action, string $event_link = null)
    {
        $user = JWTAuth::parseToken()->authenticate();
        $activity = activity()
            ->causedBy($user->id)
            ->event($action);
        if ($event_link !== null) {
            $activity->withProperties(['event_link' => $event_link]); // Event Link
        }
        $activity->log($model);
    }
    public function ManagerlogActivity(string $model, string $action, string $school_id, $form_number = null)
    {
        $user = JWTAuth::parseToken()->authenticate();
        $properties = ['school_id' => $school_id];

        // Add the event link if provided
        if ($form_number !== null) {
            $properties['form_number'] = $form_number;
        }

        activity()
            ->causedBy($user->id) // user_id
            ->event($action) // Sets the event name
            ->withProperties($properties) // School ID
            ->log($model);
    }
}
