<?php

namespace App\Traits;

use Illuminate\Database\Eloquent\SoftDeletes;

trait CascadeSoftDeletes
{
    public static function bootCascadeSoftDeletes()
    {
        static::deleting(function ($model) {
            if (!$model->isForceDeleting()) {
                foreach ($model->getCascadeDeletes() as $relation) {
                    $model->$relation()->delete();
                }
            }
        });

        static::forceDeleted(function ($model) {
            foreach ($model->getCascadeDeletes() as $relation) {
                $model->$relation()->forceDelete();
            }
        });
        static::restoring(function ($model) {
            foreach ($model->getCascadeDeletes() as $relation) {
                $model->$relation()->onlyTrashed()->restore();
            }
        });
    }

    public function getCascadeDeletes()
    {
        return $this->cascadeDeletes ?? [];
    }
}
