<?php

namespace App\Strategies;

use App\Helpers\Helper;
use App\Http\Resources\ManagerDashboard\TeamAndCommitteeMeetings\MeetingResource;
use App\Models\ManagerDashboard\Assignments\AssignmentCommittee;
use App\Models\ManagerDashboard\Assignments\GeneralAssignment;
use Carbon\Carbon;

class NamozegGeneralAssignmentHandler implements NamozegStrategy
{
    public function handle($school, $request, $namozeg_version,$type=null)
    {
        $query = GeneralAssignment::with('generalAssignmentEmployees.employee')->where('school_id', $school->id)->where('namazeg_version_id', $namozeg_version->id);

        if($type == 'trashed') {
            $query->withTrashed();
        }

        $generalAssignment = $query->firstOrFail();

        return [
            'assignment_id' => $generalAssignment->id,
            'school_id' => $generalAssignment->school_id,
            'namozeg_serial_number' => $generalAssignment->namozegVersion?->serial_number,
            'date_options' => Helper::getDateOptions($generalAssignment->date, $generalAssignment->type),
            'assignment_duration' => $generalAssignment->duration?->year,
            'details' => $generalAssignment->details,
            'employees' => $generalAssignment->generalAssignmentEmployees->map(function ($generalAssignmentEmployee) {

                return [
                    'id' => $generalAssignmentEmployee->employee?->id,
                    'name' => $generalAssignmentEmployee->employee?->name,
                    'ssn' => $generalAssignmentEmployee->employee?->ssn,
                    'specialization' => $generalAssignmentEmployee->employee?->specialization?->title,
                ];
            }),
        ];
    }
}
