<?php

namespace App\Strategies;

use App\Http\Resources\ManagerDashboard\Exams\NamazegPlans\AnswerSheetProgressResource;
use App\Models\ManagerDashboard\Exams\NamazegPlans\NamozegAnswerSheetProgress\AnswerSheetProgress;
use App\Helpers\Helper;

use App\Models\ManagerDashboard\Tables\Exams\TableExam;
use App\Models\ManagerDashboard\Tables\Exams\TableExamDay;
use App\Http\Resources\ManagerDashboard\Tables\Exams\TableExamNamazegResource;

class Namozeg98Handler implements NamozegStrategy
{
    public function handle($school, $request, $namozeg_version, $type = null)
    {

        $query = AnswerSheetProgress::with('namozegVersion', 'schoolClass')->where('namazeg_version_id', $namozeg_version->id);

        if ($type == 'trashed') {
            $query->withTrashed();
        }

        $assignment = $query->firstOrFail();

        $assignment_resource = new AnswerSheetProgressResource($assignment);

        // Get current school year and semester
        $current_school_year = $school->current_school_year;
        $current_semester = Helper::getCurrentSchoolSemester()['name'];

        $commonResponse = [
            'current_school_year' => $current_school_year,
            'current_semester' => $current_semester,
            'floor' => 'الاول',
        ];


        $tableExamIds = TableExamDay::where('class_id', $assignment->schoolClass_id)->pluck('table_exam_id')->unique()->toArray();
        if ($tableExamIds) {
            $tableExam = new TableExamNamazegResource(TableExam::whereIn('id', $tableExamIds)->where('exam_type', 'final')->first());
        }


        return [
            'data' => $assignment_resource,
            'school_context' => $commonResponse,
            'table_exam_data' => $tableExam ?? "لا يوجد جدول اختبارات لهذه المدرسة",
        ];
    }
}
