<?php

namespace App\Strategies;

use App\Helpers\Helper;
use App\Http\Resources\ManagerDashboard\Exams\StudentCommittes\CommitteeDataResource;
use App\Models\AdminDashboard\School\SchoolEmployee;
use App\Models\ManagerDashboard\Exams\StudentCommittees\StudentCommittee;
use App\Services\Exams\CommitteeService;

class Namozeg61Handler implements NamozegStrategy
{
    public function handle($school, $request, $namozeg_version, $type = null)
    {
        $committee = StudentCommittee::where('namazeg_version_id', $namozeg_version->id)->firstOrFail();
        $data = (new CommitteeService())->getCommitteeDetails($school,$committee);

        if ($type == 'trashed') {
            $committee->withTrashed();
        }

        // Get current school year and semester
        $current_school_year = $school->current_school_year;
        $current_semester = Helper::getCurrentSchoolSemester()['name'];

        $commonResponse = [
            'current_school_year' => $current_school_year,
            'current_semester' => $current_semester,
            'floor' => 'الاول',
        ];
        return
            [
                'data' => $data,
                'school_context' => $commonResponse,
            ];
    }
}
