<?php

namespace App\Strategies;

use App\Helpers\Helper;
use App\Http\Resources\ManagerDashboard\Tables\ClassRoomVisits\ClassroomVisitCollection;
use App\Models\AdminDashboard\School\School;
use App\Models\AdminDashboard\School\SchoolEmployee;
use App\Models\AdminDashboard\School\SchoolSemester;
use App\Models\ManagerDashboard\OfficialSpeeches\Letter;
use App\Models\ManagerDashboard\Tables\ClassRoomVisits\ClassroomVisit;
use Carbon\Carbon;

class Namozeg50Handler implements NamozegStrategy
{
    public function handle($school, $request, $namozeg_version, $type = null)
    {
        // Query to get the semester ID based on namozeg version
        $query = ClassroomVisit::with('semesterNamozegVersion')->where('semester_namazeg_version_id', $namozeg_version->id);
        $semester_id = $query->firstOrFail()->semester_id;

        // Get all classroom visits for the specific school and semester
        $semesterVisites = ClassroomVisit::where('school_id', $school->id)->where('semester_id', $semester_id)->get();

        // If we want to include trashed records, we adjust the query
        if ($type == 'trashed') {
            $semesterVisites->withTrashed();
        }

        // Fetch the current school manager
        $school_manager = SchoolEmployee::select('id', 'name')
            ->where('school_id', $school->id)
            ->where('current_work_id', 1)
            ->first();

        // Get current school year and semester
        $current_school_year = $school->current_school_year;
        $current_semester = Helper::getCurrentSchoolSemester()['name'];


        return [
            'data' => $semesterVisites->map(function ($visit) {

                return [
                    'id' => $visit->id,
                    'semester_id' => $visit->semester_id,
                    'visiting_teacher_id' => $visit->visitingTeacher->id,
                    'visiting_teacher' => $visit->visitingTeacher?->name,
                    'visited_teacher_id' => $visit->visitedTeacher?->id,
                    'visited_teacher' => $visit->visitedTeacher?->name,
                    'period_id' => $visit->period->id,
                    'period' => $visit->period->name,
                    'subject_id' => $visit->subject->id,
                    'subject' => $visit->subject->name,
                    'school_class_id' => $visit->class?->id,
                    'class_id' => $visit->class->className?->id,
                    'class' => $visit->class->className?->name,
                    'classNumber' => $visit->class->class_number,
                    'day' => Carbon::createFromFormat('d/m/Y', $visit->date)->translatedFormat('l'),
                    'date_options' => Helper::getDateOptions($visit->date, $visit->type),
                ];
            }),
            'school_manager' => $school_manager, // Include this outside the map() closure
            'current_school_year' => $current_school_year,
            'current_semester' => $current_semester,
        ];
    }
}
