<?php

namespace App\Strategies;

use App\Helpers\Helper;
use App\Models\AdminDashboard\School\SchoolEmployee;
use App\Models\AdminDashboard\School\SchoolSemester;
use App\Models\AdminDashboard\School\SemesterWeekDay;
use App\Models\ManagerDashboard\Tables\ShiftSchedule\ShiftSchedule;
use App\Models\ManagerDashboard\Tables\ShiftSchedule\ShiftTeacher;
use App\Models\ManagerDashboard\Tables\WaitingPeriodsSchedule\WaitingPeriodsSchedule;
use Carbon\Carbon;

class Namozeg47Handler implements NamozegStrategy
{
    public function handle($school, $request, $namozeg_version,$type=null)
    {
        $query = ShiftSchedule::where('namazeg_version_id', $namozeg_version->id);

        if($type == 'trashed') {
            $query->withTrashed();
        }

        $namozeg = $query->firstOrFail();

        $shiftScheduleTeachers = ShiftTeacher::where('shift_schedule_id', $namozeg->id)->get();

        $shiftScheduleTeachers = $shiftScheduleTeachers->map(function ($shiftScheduleTeacher) {

            $teacherIds = explode(',', $shiftScheduleTeacher->school_employee_id);
            $teachers = SchoolEmployee::whereIn('id', $teacherIds)->get(['id', 'name']);

            $mappedTeachers = $teachers->map(function ($teacher) {
                return [
                    'name' => $teacher->name
                ];
            });

            return [
                'teachers' => $mappedTeachers,
                'date' => $shiftScheduleTeacher->day?->semesterWeekDay?->date,
            ];
        })->all();


        $schoolManager = SchoolEmployee::where('school_id' , $school->id)->first();

        return [
            'school_year' => Helper::getSchoolYear(),
            'semester' => $namozeg->semester?->name,
            'week' => $namozeg->week?->name,
            'shift_schedule_teachers' => $shiftScheduleTeachers,
            'school_manager'=>$schoolManager->name
        ];
    }
}
