<?php

namespace App\Strategies;

use App\Helpers\Helper;
use App\Http\Resources\ManagerDashboard\Reports\ManagerReport\AbsentLateReportResource;
use App\Models\ManagerDashboard\Reports\ManagerReports\AbsentLate;

use App\Models\ManagerDashboard\Reports\StudentAdmisnstrativeReport\StudentAdminstrativeAbsentLate;
use App\Http\Resources\ManagerDashboard\Reports\StudentAdminstrativeReport\StudentAdminstrativeAbsentLateReportResource;

use App\Models\ManagerDashboard\Reports\SchoolAdmisnstrativeReport\SchoolAdminstrativeAbsentLate;
use App\Http\Resources\ManagerDashboard\Reports\SchoolAdminstrativeReport\SchoolAdminstrativeAbsentLateReportResource;

use App\Models\AdminDashboard\School\SchoolEmployee;

class Namozeg271Handler implements NamozegStrategy
{
    public function handle($school, $request, $namozeg_version,$type=null)
    {

        if($request->current_work_id == 1){
            $query = AbsentLate::where('namazeg_version_id', $namozeg_version->id);
            if($type == 'trashed') {
                $query->withTrashed();
            }
            $report = $query->firstOrFail();
            $report = new AbsentLateReportResource($report);
        }

        if($request->current_work_id == 7){
            $query = StudentAdminstrativeAbsentLate::where('namazeg_version_id', $namozeg_version->id);
            if($type == 'trashed') {
                $query->withTrashed();
            }
            $report = $query->firstOrFail();
            $report = new StudentAdminstrativeAbsentLateReportResource($report);
        }

        if($request->current_work_id == 8){
            $query = SchoolAdminstrativeAbsentLate::where('namazeg_version_id', $namozeg_version->id);
            if($type == 'trashed') {
                $query->withTrashed();
            }
            $report = $query->firstOrFail();
            $report = new SchoolAdminstrativeAbsentLateReportResource($report);
        }

        $schoolManager = SchoolEmployee::where('school_id' , $school->id)->first();


        return [
            'school_year' => Helper::getSchoolYear(),
            'school_manager'=>$schoolManager->name,
            'report_data'=>$report,
        ];
    }
}
