<?php

namespace App\Strategies;

use App\Helpers\Helper;
use App\Models\AdminDashboard\School\SchoolEmployee;
use App\Models\ManagerDashboard\Namazeg\NamazegTeacherExcuse;
use Carbon\Carbon;

class Namozeg230Handler implements NamozegStrategy
{
    public function handle($school, $request, $namozeg_version,$type=null)
    {
        $query = NamazegTeacherExcuse::with('employee')->where('namazeg_version_id', $namozeg_version->id);

        if($type == 'trashed') {
            $query->withTrashed();
        }

        $namozeg = $query->firstOrFail();
        $manager_name = SchoolEmployee::where('school_id', $school->id)->where('current_work_id', 1)->first()?->name;
     
        return [
            'form_number' => $namozeg_version->namozeg->form_number,
            'serial_number' => $request->serial_number,
            'school_name' => $school->name,
            'employee_name' => $namozeg->employee->name,
            'day' =>   Carbon::createFromFormat('d/m/Y', $namozeg->date)->translatedFormat('D', 'ar'),
            'date' =>   Helper::getDateOptions($namozeg->date, 'coptic') ,
            'manager_name' => $manager_name

        ];
    }
}
