<?php

namespace App\Strategies;

use App\Helpers\Helper;
use App\Http\Resources\ManagerDashboard\Tables\ClassRoomVisits\ClassroomVisitCollection;
use App\Models\AdminDashboard\School\SchoolEmployee;
use App\Models\AdminDashboard\School\SchoolSemester;
use App\Models\ManagerDashboard\OfficialSpeeches\Letter;
use App\Models\ManagerDashboard\Tables\ClassRoomVisits\ClassroomVisit;
use Carbon\Carbon;

class Namozeg229Handler implements NamozegStrategy
{
    public function handle($school, $request, $namozeg_version, $type = null)
    {
        $query = ClassroomVisit::with('namozegVersion')->where('namazeg_version_id', $namozeg_version->id);

        if ($type == 'trashed') {
            $query->withTrashed();
        }

        $ClassroomVisit = $query->firstOrFail();
        $school_manager = SchoolEmployee::select('id', 'name')
        ->where('school_id', $school->id)
        ->where('current_work_id', 1)
        ->first();
        
            // Get current school year and semester
        $current_school_year =$school->current_school_year;
        $current_semester = Helper::getCurrentSchoolSemester()['name'];
        
        return [
            'id' => $ClassroomVisit->id,
            'visiting_teacher_id' => $ClassroomVisit->visitingTeacher->id,
            'visiting_teacher' => $ClassroomVisit->visitingTeacher?->name,
            'visited_teacher_id' => $ClassroomVisit->visitedTeacher?->id,
            'visited_teacher' => $ClassroomVisit->visitedTeacher?->name,
            'period_id' => $ClassroomVisit->period->id,
            'period' => $ClassroomVisit->period->name,
            'subject_id' => $ClassroomVisit->subject->id,
            'subject' => $ClassroomVisit->subject->name,
            'school_class_id' => $ClassroomVisit->class?->id,
            'class_id' => $ClassroomVisit->class->className?->id,
            'class' => $ClassroomVisit->class->className->name,
            'classNumber' => $ClassroomVisit->class->class_number,
            'day' => Carbon::createFromFormat('d/m/Y', $ClassroomVisit->date)->translatedFormat('l'),
            'date_options' => Helper::getDateOptions($ClassroomVisit->date, $ClassroomVisit->type),
            'school_manger' => $school_manager,
            'current_school_year' => $current_school_year,
            'current_semester' => $current_semester,
        ];
    }
}
