<?php

namespace App\Strategies;

use App\Models\AdminDashboard\School\SchoolEmployee;
use App\Models\ManagerDashboard\Circulars\StudentGeneralCircular;

class Namozeg226Handler implements NamozegStrategy
{
    public function handle($school, $request, $namozeg_version, $type = null)
    {
        $query = StudentGeneralCircular::with('students')->where('namazeg_version_id', $namozeg_version->id);

        if ($type == 'trashed') {
            $query->withTrashed();
        }

        $namozeg = $query->firstOrFail();
        $students = $namozeg->students()->get()->map(function ($item) {
            return [
                'name' => $item->name,
                'ssn' => $item->ssn,
            ];
        });
        
        $student_affairs_agent = SchoolEmployee::where('school_id', $school->id)->where('current_work_id', 7)->first()?->name;

        return [
            'form_number' => $namozeg_version->namozeg->form_number,
            'serial_number' => $request->serial_number,
            'class_name' => $namozeg?->className?->name ?? 'جميع الصفوف',
            'class_number' => $namozeg?->class_number ?? 'جميع الفصول',
            'about' => $namozeg->title,
            'to' => $students,
            'student_affairs_agent' => $student_affairs_agent,
        ];
    }
}
