<?php

namespace App\Strategies;

use App\Models\ManagerDashboard\Namazeg\NamazegStudentFollow;

class Namozeg224Handler implements NamozegStrategy
{
    public function handle($school, $request, $namozeg_version,$type=null)
    {
        $query = NamazegStudentFollow::with('student')->where('namazeg_version_id', $namozeg_version->id);

        if($type == 'trashed') {
            $query->withTrashed();
        }

        $namozeg = $query->firstOrFail();
     
        return [
            'form_number' => $namozeg_version->namozeg->form_number,
            'serial_number' => $request->serial_number,
            'current_school_year' => $school->current_school_year,
            'student_name' => $namozeg->student->name,
            'class_name' => $namozeg->student->schoolClass->className?->name,
            'class_number' => $namozeg->student->schoolClass->class_number,
        ];
    }
}
