<?php

namespace App\Strategies;

use App\Helpers\Helper;
use App\Models\AdminDashboard\School\SchoolEmployee;
use App\Models\ManagerDashboard\Namazeg\NamazegCircularAttendance;

class Namozeg196Handler implements NamozegStrategy
{
    public function handle($school, $request, $namozeg_version,$type=null)
    {
        $query = NamazegCircularAttendance::where('namazeg_version_id', $namozeg_version->id)
            ->select('directed_to', 'issued_by', 'about', 'date');
        
        if($type == 'trashed') {
            $query->withTrashed();
        }
        
        $model = $query->first();
        $date_options = $model->date ? Helper::getDateOptions($model->date, 'coptic') : '';

        // Determine employees based on the 'directed_to' field
        if ($model->directed_to == "teachers") {
            $employees = SchoolEmployee::where('type', 'teacher')
                ->where('school_id', $school->id)
                ->pluck('name')
                ->toArray();
        } elseif ($model->directed_to == "adminstrators") {
            $employees = SchoolEmployee::where('type', 'adminstrative')
                ->where('school_id', $school->id)
                ->pluck('name')
                ->toArray();
        } else {
            $employees = SchoolEmployee::where('school_id', $school->id)
                ->pluck('name')
                ->toArray();
        }

        return [
            'form_number' => $namozeg_version->namozeg->form_number,
            'current_school_year' => $school->current_school_year,
            'semester_name' => Helper::getCurrentSchoolSemester($school->id)->name,
            'serial_number' => $request->serial_number,
            'date' => $date_options,
            'data' => $employees
        ];
    }
}
