<?php

namespace App\Strategies;

use App\Models\AdminDashboard\School\SchoolGrade;
use App\Models\ManagerDashboard\Namazeg\NamazegStudentData;

class Namozeg191Handler implements NamozegStrategy
{
    public function handle($school, $request, $namozeg_version,$type=null)
    {
        $query = NamazegStudentData::with('student')->where('namazeg_version_id', $namozeg_version->id);

        if($type == 'trashed') {
            $query->withTrashed();
        }

        $namozeg = $query->firstOrFail();
        $school_grade = SchoolGrade::findOrFail($namozeg->student->schoolClass?->className->school_grade_id);
        
        return [
            'form_number' => $namozeg_version->namozeg->form_number,
            'serial_number' => $request->serial_number,
            'current_school_year' => $school->current_school_year,
            'student_name' => $namozeg->student->name,
            'grade_name' => $school_grade->name,
            'class_name' => $namozeg->student->schoolClass?->className?->name,
            'class_number' => $namozeg->student->schoolClass->class_number,
            'ssn' => $namozeg->student->ssn,
            'nationality' => $namozeg->student->nationality
        ];
    }
}
