<?php

namespace App\Strategies;

use App\Helpers\Helper;
use App\Models\AdminDashboard\School\SchoolEmployee;
use App\Models\ManagerDashboard\Namazeg\NamazegEvacuationPlanReport;
use Carbon\Carbon;

class Namozeg189Handler implements NamozegStrategy
{
    public function handle($school, $request, $namozeg_version,$type=null)
    {
        $query = NamazegEvacuationPlanReport::with('images')->where('namazeg_version_id', $namozeg_version->id);

        if($type == 'trashed') {
            $query->withTrashed();
        }

        $namozeg = $query->firstOrFail();

        $manager_name = SchoolEmployee::where('school_id', $school->id)->where('current_work_id', 1)->first()?->name;
        // وكيل الشئون المدرسية
        $supervisor_name = SchoolEmployee::where('school_id', $school->id)->where('current_work_id', 8)->first()?->name;
   
        return [
            'form_number' => $namozeg_version->namozeg->form_number,
            'serial_number' => $request->serial_number,

            'day' =>   Carbon::createFromFormat('d/m/Y', $namozeg->date)->translatedFormat('D', 'ar'),
            'date' =>   Helper::getDateOptions($namozeg->date, 'coptic') , 
            'time' =>   $namozeg->time,
            'n_employees' => $namozeg->n_employees,
            'n_students' => $namozeg->n_students,
            'images' => $namozeg->images->map(function ($image) {
                return ["id" => $image->id, "image" => Helper::uploadedImagesPath('evacuationNamozeg', $image->image)];
            }),
            'manager_name' => $manager_name,
            'supervisor_name' => $supervisor_name,
            'safety_man' =>$namozeg->safety_man,
            'duration' =>$namozeg->duration,

        ];
    }
}
