<?php

namespace App\Strategies;

use App\Models\AdminDashboard\School\SchoolEmployeeAttendance;
use App\Models\ManagerDashboard\Namazeg\NamazegAbsenceQuestioning;
use App\Models\ManagerDashboard\Namazeg\NamazegMonitoringLateAbsenceTeacher;
use App\Models\ManagerDashboard\Namazeg\NamazegNotifyLateLeaving;
use Carbon\Carbon;

class Namozeg177Handler implements NamozegStrategy
{
    public function handle($school, $request, $namozeg_version, $type = null)
    {
        $query = NamazegMonitoringLateAbsenceTeacher::with('employee')->where('namazeg_version_id', $namozeg_version->id);

        if ($type == 'trashed') {
            $query->withTrashed();
        }

        $namozeg = $query->firstOrFail();

        // absent teachers
        $absence_dates = SchoolEmployeeAttendance::where('school_employee_id', $namozeg->employee->id)
            ->where('status', 'absent')->select('date', 'absence_reason')->get();
        $absence_dates = $absence_dates->map(fn($absence_date) => [
            'day' =>   Carbon::createFromFormat('d/m/Y', $absence_date->date)->translatedFormat('D', 'ar'),
            'date' => $absence_date->date,
            'absence_reason' => $absence_date->absence_reason,
        ]);
        $absence_questionings = NamazegAbsenceQuestioning::with('action')
            ->whereHas('action', function ($query) {
                $query->where('absence_questioning_option_id', 3);
            })
            ->where('employee_id', $namozeg->employee->id)
            ->get();
        $absence_questionings = $absence_questionings->map(fn($absence_questioning) => [
            'day' =>   Carbon::createFromFormat('d/m/Y', $absence_questioning->absence_date)->translatedFormat('D', 'ar'),
            'date' => $absence_questioning->absence_date,
            'absence_reason' => $absence_questioning->action->action->name,
        ]);
        $absence_dates  = $absence_dates->concat($absence_questionings);

        // late teachers
        $late_dates = NamazegNotifyLateLeaving::where('employee_id', $namozeg->employee->id)
        ->get();
        $late_dates = $late_dates->map(fn($late_date) => [
            'day' =>   Carbon::createFromFormat('d/m/Y', $late_date->date)->translatedFormat('D', 'ar'),
            'date' => $late_date->date,
            'time' => 20,
            'type' => null
        ]);
        
        $late_attendance_dates = SchoolEmployeeAttendance::where('school_employee_id', $namozeg->employee->id)
            ->where('status', 'late')->select('date', 'late_reason', 'late_from_time', 'late_to_time')->get();
        $late_attendance_dates = $late_attendance_dates->map(fn($late_attendance_date) => [
            'day' =>   Carbon::createFromFormat('d/m/Y', $late_attendance_date->date)->translatedFormat('D', 'ar'),
            'date' => $late_attendance_date->date,
            'time' => $late_attendance_date->late_reason==null?Carbon::createFromFormat('h:i A', str_replace(['ص', 'م'], ['AM', 'PM'], $late_attendance_date->late_from_time))
                ->diffInMinutes(
                    Carbon::createFromFormat('h:i A', str_replace(['ص', 'م'], ['AM', 'PM'], $late_attendance_date->late_to_time))
                ):null,
            'type' => $late_attendance_date->late_reason
        ]);

        $late_dates = $late_dates->concat($late_attendance_dates);


        // Holidays
        $holidays = NamazegAbsenceQuestioning::with('action')
            ->whereHas('action', function ($query) {
                $query->whereIn('absence_questioning_option_id', [1,2]);
            })
            ->where('employee_id', $namozeg->employee->id)
            ->get();
        $holidays = $holidays->map(fn($holiday) => [
            'day' =>   Carbon::createFromFormat('d/m/Y', $holiday->absence_date)->translatedFormat('D', 'ar'),
            'date' => $holiday->absence_date,
            'type' => $holiday->action? $holiday->action->label_report_type:'اجازة ضرورية',
        ]);


        return [
            'form_number' => $namozeg_version->namozeg->form_number,
            'serial_number' => $request->serial_number,
            'current_school_year' => $school->current_school_year,
            'school_name' => $school->name,
            'ssn' => $namozeg->employee->ssn,
            'employee_name' => $namozeg->employee->name,
            'specialization' => $namozeg->employee->specialization?->title,
            "absence_days" => $absence_dates->sortBy('date')->values(),
            "late_dates" => $late_dates->sortBy('date')->values(),
            "holidays" => $holidays->sortBy('date')->values(),
        ];
    }
}
