<?php

namespace App\Strategies;

use App\Models\AdminDashboard\School\SchoolEmployee;
use App\Models\ManagerDashboard\Namazeg\NamazegDescionSumhoursLateleaving;
use Carbon\Carbon;

class Namozeg172Handler implements NamozegStrategy
{
    public function handle($school, $request, $namozeg_version,$type=null)
    {
        $query = NamazegDescionSumhoursLateleaving::with('employee')->where('namazeg_version_id', $namozeg_version->id);

        if($type == 'trashed') {
            $query->withTrashed();
        }

        $namozeg = $query->firstOrFail();
        $manager_name = SchoolEmployee::where('school_id', $school->id)->where('current_work_id', 1)->first()?->name;

        return [
            'form_number' => $namozeg_version->namozeg->form_number,
            'serial_number' => $request->serial_number,
            'current_school_year' => $school->current_school_year,
            'school_name' => $school->name,
            'ssn' => $namozeg->employee->ssn,
            'employee_name' => $namozeg->employee->name,
            'specialization' => $namozeg->employee->specialization?->title,
            'currentWork' => $namozeg->employee->currentWork?->job_title,
            'manager_name' => $manager_name,
            'n_days' => $namozeg->n_days,
            'n_hours' => $namozeg->n_hours            
        ];
    }
}
