<?php

namespace App\Strategies;

use App\Models\AdminDashboard\School\SchoolEmployee;
use App\Models\ManagerDashboard\Namazeg\NamazegNotifyLateLeaving;
use Carbon\Carbon;
use App\Helpers\Helper;


class Namozeg171Handler implements NamozegStrategy
{
    public function handle($school, $request, $namozeg_version,$type=null)
    {
        $query = NamazegNotifyLateLeaving::with('employee')->where('namazeg_version_id', $namozeg_version->id);

        if($type == 'trashed') {
            $query->withTrashed();
        }

        $namozeg = $query->firstOrFail();
        $manager_name = SchoolEmployee::where('school_id', $school->id)->where('current_work_id', 1)->first()?->name;

        $data = [
            'form_number' => $namozeg_version->namozeg->form_number,
            'serial_number' => $request->serial_number,
            'current_school_year' => $school->current_school_year,

            'school_name' => $school->name,
            'ssn' => $namozeg->employee->ssn,
            'type' => $namozeg->type,
            'employee_name' => $namozeg->employee->name,
            'specialization' => $namozeg->employee->specialization?->title,
            'currentWork' => $namozeg->employee->currentWork?->job_title,
            'manager_name' => $manager_name,
            'level' => $namozeg->level,
            'day' =>   Carbon::createFromFormat('d/m/Y', $namozeg->date)->translatedFormat('D', 'ar'),
            'date' =>   Helper::getDateOptions($namozeg->date, 'coptic') ,
        ];
        if ($namozeg->type == "during") {
            $data['start_date'] = $namozeg->start_date;
            $data['end_date'] = $namozeg->end_date;
        } elseif ($namozeg->type == "start") {
            // $data['start_day'] =   Carbon::createFromFormat('d/m/Y', $namozeg->start_date)->translatedFormat('D', 'ar');
            $data['start_date'] = $namozeg->start_date;
        } else {
            // $data['end_day'] =   Carbon::createFromFormat('d/m/Y', $namozeg->end_date)->translatedFormat('D', 'ar');
            $data['end_date'] = $namozeg->end_date;
        }
        return $data;
    }
}