<?php

namespace App\Strategies;

use App\Helpers\Helper;
use App\Models\AdminDashboard\School\SchoolEmployee;
use App\Models\ManagerDashboard\Namazeg\NamazegAbsenceQuestioning;
use Carbon\Carbon;

class Namozeg169Handler implements NamozegStrategy
{
    public function handle($school, $request, $namozeg_version,$type=null)
    {
        $query = NamazegAbsenceQuestioning::with('employee')->where('namazeg_version_id', $namozeg_version->id);

        if($type == 'trashed') {
            $query->withTrashed();
        }

        $namozeg = $query->firstOrFail();
        $manager_name = SchoolEmployee::where('school_id', $school->id)->where('current_work_id', 1)->first()?->name;
        $action = $namozeg->action?->action;
        $action['n_days'] = $namozeg->action?->n_days;
        $action['report_type'] = $namozeg->action?->report_type;
        unset($action['created_at'], $action['updated_at']);
        return [
            'form_number' => $namozeg_version->namozeg->form_number,
            'serial_number' => $request->serial_number,
            'current_school_year' => $school->current_school_year,
            'school_name' => $school->name,
            'manager_name' => $manager_name,
            'ssn' => $namozeg->employee->ssn,
            'employee_name' => $namozeg->employee->name,
            'specialization' => $namozeg->employee->specialization?->title,
            'currentWork' => $namozeg->employee->currentWork?->job_title,
            'absence_day' =>   Carbon::createFromFormat('d/m/Y', $namozeg->absence_date)->translatedFormat('D', 'ar'),
            'absence_date' =>   Helper::getDateOptions($namozeg->absence_date, 'coptic'),
            'attendance_day' =>   Carbon::createFromFormat('d/m/Y', $namozeg->attendance_date)->translatedFormat('D', 'ar'),
            'attendance_date' =>   Helper::getDateOptions($namozeg->attendance_date, 'coptic'),
            'n_days' => $this->n_days($namozeg->absence_date, $namozeg->attendance_date),
            'action' => $action

        ];
    }
    private function n_days($absence_date, $attendance_date)
    {

        $absenceDate = Carbon::createFromFormat('d/m/Y', $absence_date);
        $attendanceDate = Carbon::createFromFormat('d/m/Y', $attendance_date);

        $daysDifference = $absenceDate->diffInDays($attendanceDate) + 1;

        // Loop through the date range and check if Friday or Saturday exists between the two dates
        $hasFridaysOrSaturdaysBetween = false;

        for ($date = $absenceDate->copy(); $date->lte($attendanceDate); $date->addDay()) {
            if ($date->isFriday() || $date->isSaturday()) {
                $hasFridaysOrSaturdaysBetween = true;
                break; // No need to continue if we found a Friday or Saturday
            }
        }
        if (!$hasFridaysOrSaturdaysBetween) {
            // Check for holidays (Friday/Saturday) before or after the  date
            if ($absenceDate->copy()->subDay()->isSaturday()) {
                $daysDifference += 2;
            }

            if ($absenceDate->copy()->addDay()->isFriday()) {
                $daysDifference += 2;
            }
            if ($attendanceDate->copy()->subDay()->isSaturday()) {
                $daysDifference += 2;
            }

            if ($attendanceDate->copy()->addDay()->isFriday()) {
                $daysDifference += 2;
            }
        }
        if ($absenceDate == $attendanceDate) {
            $daysDifference = $daysDifference - 2;
        } else {
            $daysDifference = $daysDifference - 1;
        }

        return $daysDifference;
    }
}
