<?php

namespace App\Strategies;

use App\Models\ManagerDashboard\Namazeg\NamazegEmployeeLeavingRecord;

class Namozeg168Handler implements NamozegStrategy
{
    public function handle($school, $request, $namozeg_version,$type=null)
    {
        $query = NamazegEmployeeLeavingRecord::with('employee')->where('namazeg_version_id', $namozeg_version->id);

        if($type == 'trashed') {
            $query->withTrashed();
        }

        $namozeg = $query->firstOrFail();
     
        return [
            'form_number' => $namozeg_version->namozeg->form_number,
            'serial_number' => $request->serial_number,
            'current_school_year' => $school->current_school_year,
            'school_name' => $school->name,
            'ssn' => $namozeg->employee->ssn,
            'employee_name' => $namozeg->employee->name,
            'specialization' => $namozeg->employee->specialization?->title,
        ];
    }
}
