<?php

namespace App\Strategies;

use App\Helpers\Helper;
use App\Models\AdminDashboard\School\SchoolEmployee;
use App\Models\AdminDashboard\School\SchoolGrade;
use App\Models\ManagerDashboard\Namazeg\NamazegSchoolCommitment;

class Namozeg144Handler implements NamozegStrategy
{
    public function handle($school, $request, $namozeg_version,$type=null)
    {
        $query = NamazegSchoolCommitment::with('student')->where('namazeg_version_id', $namozeg_version->id);

        if($type == 'trashed') {
            $query->withTrashed();
        }

        $namozeg = $query->firstOrFail();
        $school_grade = SchoolGrade::findOrFail($namozeg->student->schoolClass?->className->school_grade_id);
        $manager_name = SchoolEmployee::where('school_id', $school->id)->where('current_work_id', 1)->first()?->name;
        $manager_assistant_name = SchoolEmployee::where('school_id', $school->id)->where('current_work_id', 6)->first()?->name;
        return [
            'form_number' => $namozeg_version->namozeg->form_number,
            'serial_number' => $request->serial_number,
            'current_school_year' => $school->current_school_year,
            'student_name' => $namozeg->student->name,
            'class_name' => $namozeg->student->schoolClass?->className?->name,
            'grade_name' => $school_grade->name,
            'manager_name' => $manager_name,
            'manager_assistant_name' => $manager_assistant_name,
        ];
    }
}
