<?php

namespace App\Strategies;

use App\Helpers\Helper;
use App\Models\ManagerDashboard\Violations\ViolationStudentPunishment;

class Namozeg140Handler implements NamozegStrategy
{
    public function handle($school, $request, $namozeg_version, $type = null)
    {
        $punishment = ViolationStudentPunishment::with('VStudentTitle')->where('namazeg_version_id', $namozeg_version->id)->first();
        $student = $punishment->VStudentTitle->ViolationStudent->student;
        $punishment_category = $punishment->VStudentTitle->ViolationStudent->category;
        $violation_type = $punishment->VStudentTitle->ViolationStudent->type;
        // $semester_date = $namozeg_version->created_at->format('d/m/Y');
        // $semester =  Helper::getCurrentSchoolSemester($semester_date);
        return [
            'form_number' => $namozeg_version->namozeg->form_number,
            'serial_number' => $request->serial_number,
            'student_name' => $student->name,
            'class_name' => $student->schoolClass->className?->name,
            'school_name' => $school->name,
            'school_grade' => $student->schoolClass->className?->grade?->name,
            'class_number' => $student->schoolClass->class_number,
            'violation_name' => $violation_type ? $violation_type->name : $punishment->VStudentTitle->ViolationStudent->other_type,
            'violation_grade' => $punishment->VStudentTitle->ViolationStudent->violationGrade?->name
        ];
    }
}
