<?php

namespace App\Strategies;

use App\Helpers\Helper;
use App\Models\AdminDashboard\School\SchoolEmployee;
use App\Models\ManagerDashboard\Namazeg\NamazegCircularAttendance;
use App\Models\ManagerDashboard\Namazeg\NamazegTeacherPerformanceFollow;

class Namozeg135Handler implements NamozegStrategy
{
    public function handle($school, $request, $namozeg_version,$type=null)
    {
        $query = NamazegTeacherPerformanceFollow::where('namazeg_version_id', $namozeg_version->id);

        if($type == 'trashed') {
            $query->withTrashed();
        }

        $namozeg = $query->firstOrFail();
        $employee = SchoolEmployee::findOrFail($namozeg->school_employee_id);

        $manager_name = SchoolEmployee::where('school_id', $employee->school_id)->where('current_work_id',1)->first()?->name;
        $manager_assistant_name = SchoolEmployee::where('school_id', $employee->school_id)->where('current_work_id',6)->first()?->name;
        $current_semester = Helper::getCurrentSchoolSemester();
        return [
            'form_number' => $namozeg_version->namozeg->form_number,
            'serial_number' => $request->serial_number,
            'current_school_year' => $school->current_school_year,
            'employee_name' => $employee?->name,
            'employee_specialization' => $employee?->specialization?->title,
            'manager_name' => $manager_name,
            'manager_assistant_name' => $manager_assistant_name,
            'current_semester' => $current_semester->name,
            'dates' => Helper::get_first_last_Day_of_semester_weeks($current_semester->id)
        ];
    }
}
