<?php

namespace App\Strategies;

use App\Helpers\GradeViolationsHelper;
use App\Helpers\Helper;
use App\Models\AdminDashboard\School\SchoolEmployee;
use App\Models\ManagerDashboard\Namazeg\NamazegCircularAttendance;

class Namozeg129Handler implements NamozegStrategy
{
    public function handle($school, $request, $namozeg_version,$type=null)
    {
        $circular = NamazegCircularAttendance::with('school')->where('namazeg_version_id', $namozeg_version->id)->first();
        $school = $circular->school;
        $current_school_year = $school->current_school_year;
        $date_options = Helper::getDateOptions($circular->date,'coptic');
        $current_semester = Helper::getCurrentSchoolSemester();
        //employees
        $employees = SchoolEmployee::query();
        if($circular->directed_to== "teachers"){
            $employees = $employees->where('type','teacher')->pluck('name'); 
        }elseif($circular->directed_to == "adminstrators"){
            $employees = $employees->where('type', 'adminstrative')->pluck('name'); 
        }else{
            $employees = $employees->pluck('name'); 
        }

        return [
            'current_school_year'=> $current_school_year,
            'current_semester'=> $current_semester->name,
            'school_name'=> $school->name,
            'number'=> $circular->code,
            'date_options'=> $date_options,
            'issued_by'=> $circular->issued_by,
            'about'=> $circular->about,
            'employees' => $employees 
        ];
    }
}
