<?php

namespace App\Strategies;

use App\Models\ManagerDashboard\Violations\ViolationStudent;
use App\Models\ViolationPunishment;
use Carbon\Carbon;

class Namozeg108Handler implements NamozegStrategy
{
    public function handle($school, $request, $namozeg_version, $type = null)
    {
        $violation_student_version = ViolationStudent::with('student', 'violationGrade', 'violation_titles')->where('namazeg_version_id', $namozeg_version->id)->first();
        $student_name = $violation_student_version->student->name;
        $school_class = $violation_student_version->student->schoolClass->className->name;
        $violationGrade = $violation_student_version->violationGrade->name;
        $violation_titles_records = $violation_student_version->violation_titles->filter(function ($violation_title) {
            return $violation_title->punishments->isNotEmpty();
        });
        //   $all_punishments = $violation_student_version->violationGrade?->violation_titles->flatMap(function ($title_public_violation) {
        //         return $title_public_violation->punishments->map(function ($punishment) {
        //             return $punishment->namzeg;
        //         });
        //     });


        $data = $violation_titles_records->map(function ($violation_titles_record) use ($violationGrade) {
            $violation_title_name = $violation_titles_record->title->violation_name?->name;
            $status = $violation_titles_record->status;

            $violation_title_all_punishments = ViolationPunishment::with('namzeg', 'related_punishments')
                ->where('violation_title_id', $violation_titles_record->violation_title_id)
                ->get();
            $violation_title_basic_namazeg = $violation_title_all_punishments->map(function ($violation_real_punishemnt) {
                return $violation_real_punishemnt->namzeg;
            });
            $violation_title_related_namazeg = $violation_title_all_punishments
                ->flatMap(function ($punishement_related_punishments) {
                    return $punishement_related_punishments->related_punishments
                        ->map(function ($related_punsihement_basic) {
                            return $related_punsihement_basic->namzeg;
                        });
                })
                ->filter();
            $all_title_namazeg = $violation_title_related_namazeg->merge($violation_title_basic_namazeg);
            $date = $violation_titles_record->date;
            $punishments = $all_title_namazeg->map(fn($punishment) => [
                'id' => $punishment->id,
                'name' => $punishment->name,
                'details' => $punishment->details,
                'form_number' => $punishment->form_number,
                'status' => optional($violation_titles_record->punishments->where('punishment_id', $punishment->id)->first())->status
            ]);

            return [
                'id' => $violation_titles_record->id,
                'violation_title_name' => $violation_title_name,
                'violation_grade_name' => $violationGrade,
                'status' => $status,
                'day' =>   Carbon::createFromFormat('d/m/Y', $date)->translatedFormat('D', 'ar'),
                'created_at' => $date,
                'punishments' => $punishments
            ];
        });
        $type = $violation_student_version->violation_type_id ? $violation_student_version->type?->name : $violation_student_version->other_type;
        return [
            'school_level' => $violation_student_version->student->schoolClass->className->grade->id,
            'student_name' => $student_name,
            'school_class' => $school_class,
            'violation_type' => $type,
            'data' => $data->values(),
        ];
    }
}
