<?php

namespace App\Services;

use App\Helpers\Helper;
use App\Http\Resources\AdminDashboard\AreasAndCities\AreaResource;
use App\Models\AdminDashboard\AreaAndCities\Area;
use App\Models\AdminDashboard\School\School;
use App\Models\AdminDashboard\School\SchoolClass;
use App\Models\AdminDashboard\School\SchoolEmployee;
use App\Models\ManagerDashboard\Exams\StudentCommittees\StudentCommittee;
use App\Models\ManagerDashboard\Exams\StudentCommittees\StudentCommitteeData;
use App\Models\ManagerDashboard\Exams\SupervisionCommittees\ExamSupervisionCommittee;
use App\Models\ManagerDashboard\TeacherSchedule;
use App\Models\ManagerDashboard\TeacherScheduleData;
use App\Models\Namazeg;

class NamazegService
{
    public function getNamazegData($form_number, $school_id)
    {
        // Get current school year and semester
        $current_school_year = School::findOrFail($school_id)->current_school_year;
        $current_semester = Helper::getCurrentSchoolSemester()['name'];

        $commonResponse = [
            'current_school_year' => $current_school_year,
            'current_semester' => $current_semester,
            'floor' => 'الاول',
        ];


        // Get the school manager
        $school_manager = SchoolEmployee::select('id', 'name')
            ->where('school_id', $school_id)
            ->where('current_work_id', 1)
            ->first();
        // $areas = AreaResource::collection(Area::select('id', 'name')->get());
        $schoolArea = School::findOrFail($school_id)->area;
        $schoolCity = School::findOrFail($school_id)->city;

        // $school = School::findOrFail($school_id)-
        // Helper function to fetch and map committee data
        $getMappedCommittee = function ($id) use ($school_id) {
            $committee = ExamSupervisionCommittee::with(['assignment' => function ($query) use ($school_id) {
                $query->where('school_id', $school_id);
            }])->where('id', $id)->first();

            if (!$committee) {
                return null; // Return null if committee not found
            }

            return [
                'id' => $committee->id,
                'name' => $committee->name,
                'assignment_form_number' => $committee->assignment_form_number,
                'members' => $committee->assignment?->members->map(function ($member) {
                    return [
                        'employee_id' => $member->employee->id,
                        'name' => $member->employee->name,
                        'assignment_work' => $member->assignment_work,
                        'mission' => $member->mission,
                    ];
                })->toArray(), // Convert to array
            ];
        };

        // Fetch and map committees
        $achievementCommittee = $getMappedCommittee(1);
        $controlCommittee = $getMappedCommittee(2);
        $supervisionCommittee = $getMappedCommittee(3);
        $CorrectionReviewCommittee = $getMappedCommittee(4);

        // لجان الاختبارات 

        $studentCommittees =  StudentCommittee::with('CommitteeStudents')->select('id', 'name', 'schoolclass_id')->where('school_id', $school_id)
            // ->where('semester_id', Helper::getCurrentSchoolSemester()->id)
            ->get();

        $committeeStudents = $studentCommittees->map(function ($studentCommittee) {
            return [
                'id' => $studentCommittee->id,
                'name' =>  $studentCommittee->name,
                'students' => $studentCommittee->CommitteeStudents->map(function ($student) {
                    return [
                        'id' => $student->student->id,
                        'ssn' => $student->student->ssn,
                        'name' => $student->student->name,
                        'seating_number' => $student->seat_number,
                    ];
                })
            ];
        });


        // data for form number 80 
        $committees = StudentCommittee::with(['schoolClass' => function ($query) use ($school_id) {
            $query->where('school_id', $school_id);
        }])
            ->where('school_id', $school_id)
            ->where('semester_id',  Helper::getCurrentSchoolSemester()->id)
            ->where('schoolClass_id', '!=', null)
            ->get();

        $ManualCommittees_id = StudentCommittee::where('school_id', $school_id)
            ->where('semester_id',  Helper::getCurrentSchoolSemester()->id)
            ->where('schoolClass_id', null)
            ->get()->pluck('id')->toArray();

        // $ManualCommittees_data = StudentCommitteeData::with('SchoolClass')->whereIn('committee_id',$ManualCommittees_id)->get()->groupBy('schoolclass_id');
        $ManualCommittees_data = StudentCommitteeData::with('SchoolClass')->whereIn('committee_id', $ManualCommittees_id)->get();
        $classCommitteeData = [];
        if (count($committees) > 0) {
            foreach ($committees as $committee) {
                // Determine the class name based on availability
                $className = $committee->schoolClass->className->name ?? null;
                // Check if the class already exists in the final array
                if (!isset($classCommitteeData[$className])) {
                    $classCommitteeData[$className] = [
                        'class_name' => $className,
                        'committees' => []
                    ];
                }

                // Count students
                $studentsCount = count($committee->CommitteeStudents ?? []);

                // Add committee data to the class entry
                $classCommitteeData[$className]['committees'][] = [
                    'committee_id' => $committee->id,
                    'committee_name' => $committee->name ?? 'Unnamed Committee', // Fallback name
                    'students_count' => $studentsCount,
                ];
            }
        } else {
            foreach ($ManualCommittees_data as $committee) {
                $className = $committee->SchoolClass->className->name ?? 'Unnamed Class'; // Handle potential nulls
                $committeeId = $committee->studentCommittee->id; // Get the committee ID
                $committeeName = $committee->studentCommittee->name ?? 'Unnamed Committee'; // Get the committee name

                // Check if the class already exists in the final array
                if (!isset($classCommitteeData[$className])) {
                    $classCommitteeData[$className] = [
                        'class_name' => $className,
                        'committees' => []
                    ];
                }

                // Check if the committee already exists for this class
                $existingCommittee = collect($classCommitteeData[$className]['committees'])->firstWhere('committee_id', $committeeId);
                $currentStudentCount = count(json_decode($committee->student_ids));
                if ($existingCommittee) {
                    // If it exists, sum the student counts directly in the original array
                    $classCommitteeData[$className]['committees'][array_search($committeeId, array_column($classCommitteeData[$className]['committees'], 'committee_id'))]['students_count'] += $currentStudentCount;
                } else {
                    // If it doesn't exist, add it to the committee list
                    $classCommitteeData[$className]['committees'][] = [
                        'committee_id' => $committeeId,
                        'committee_name' => $committeeName,
                        'students_count' => $currentStudentCount,
                    ];
                }
            }

            // Optionally convert the array back to a numerically indexed array
            $classCommitteeData = array_values($classCommitteeData);
        }


        // data for form number 69
        $teacher_schedules = TeacherSchedule::where('school_id', $school_id)
            ->pluck('id')
            ->toArray();

        // Get teacher schedule data filtered by subject and teacher schedule
        $teacher_schedule_data = TeacherScheduleData::with(['employee', 'subject'])  // Eager load employee and subject
            ->whereIn('teacher_schedule_id', $teacher_schedules)
            ->get();

        // Group the subjects by employee and remove duplicates
        $employees = $teacher_schedule_data->groupBy(function ($teacher_schedule_data) {
            return $teacher_schedule_data->employee->id;  // Group by employee ID
        })->map(function ($teacher_schedules) {
            // For each employee group, return the required structure
            return [
                'employee_id' => $teacher_schedules->first()->employee->id,  // Get the first employee (all belong to the same employee ID)
                'employee_name' => $teacher_schedules->first()->employee->name,  // Employee name from the first schedule
                'subjects' => $teacher_schedules->pluck('subject')->unique('id')->map(function ($subject) {
                    return [
                        'id' => $subject->id,  // Subject ID
                        'name' => $subject->name  // Subject Name
                    ];
                })->values()
            ];
        })->values(); // Reset the array keys
        
        // Define response based on form number
        $formMappings = [

            '69' => array_merge($commonResponse, [
                'employees' => $employees,
                'school_manager' => $school_manager,
            ]),

            '70' => $commonResponse,

            '71' => $commonResponse,

            '72' => $commonResponse,

            '73' => $commonResponse,

            '74' => $commonResponse,

            '76' => array_merge($commonResponse, [
                'teachers' => SchoolEmployee::select('id', 'name')->where('school_id', $school_id)->get(),
            ]),

            '77' => $commonResponse,

            '78' => $commonResponse,

            '79' => $commonResponse,

            '80' => array_merge($commonResponse, [
                'classCommittee' => array_values($classCommitteeData),
                'school_manager' => $school_manager,
            ]),

            '83' => array_merge($commonResponse, [
                'committee' => $supervisionCommittee,
                'school_manager' => $school_manager,
            ]),

            '84' => array_merge($commonResponse, [
                'committee' => $supervisionCommittee,
                'school_manager' => $school_manager,
            ]),

            '85' => array_merge($commonResponse, [
                'supervisionCommittee' => $supervisionCommittee,
                'achievementCommittee' => $achievementCommittee,
                'school_manager' => $school_manager,
            ]),

            '86' => array_merge($commonResponse, [
                'supervisionCommittee' => $supervisionCommittee,
                'achievementCommittee' => $achievementCommittee,
                'school_manager' => $school_manager,
            ]),

            '87' => array_merge($commonResponse, [
                'supervisionCommittee' => $supervisionCommittee,
                'controlCommittee' => $controlCommittee,

            ]),

            '88' => $commonResponse,

            '89' => array_merge($commonResponse, [
                'supervisionCommittee' => $supervisionCommittee,
                'controlCommittee' => $controlCommittee,
                'school_manager' => $school_manager,
            ]),

            '90' => $commonResponse,

            '91' => array_merge($commonResponse, [
                'supervisionCommittee' => $supervisionCommittee,
                'school_manager' => $school_manager,
            ]),

            '92' => array_merge($commonResponse, [
                'supervisionCommittee' => $supervisionCommittee,
                'school_manager' => $school_manager,
            ]),

            '93' => $commonResponse,

            '94' => $commonResponse,

            '95' => array_merge($commonResponse, [
                'committeeStudents' => $committeeStudents,
            ]),

            '96' => array_merge($commonResponse, [
                'studentCommittees' => $studentCommittees,
            ]),

            '97' => $commonResponse,

            '99' => array_merge($commonResponse, [
                'CorrectionReviewCommittee' => $CorrectionReviewCommittee,
                'school_manager' => $school_manager,
            ]),

            '100' => array_merge($commonResponse, [
                'CorrectionReviewCommittee' => $CorrectionReviewCommittee,
                'school_manager' => $school_manager,
            ]),

            '101' => array_merge($commonResponse, [
                'CorrectionReviewCommittee' => $CorrectionReviewCommittee,
                'school_manager' => $school_manager,
            ]),

            '102' => array_merge($commonResponse),

            '103' => array_merge($commonResponse, ['school_manager' => $school_manager]),

            '104' =>  array_merge($commonResponse, [
                'CorrectionReviewCommittee' => $CorrectionReviewCommittee,
                'school_manager' => $school_manager,
                'schoolArea' => $schoolArea->name,
                'schoolCity' => $schoolCity->name
            ]),

            '105' => array_merge($commonResponse, ['school_manager' => $school_manager]),

            '106' => array_merge($commonResponse, [
                'CorrectionReviewCommittee' => $CorrectionReviewCommittee,
                'school_manager' => $school_manager,
            ]),

            '107' => array_merge($commonResponse),


        ];

        return $formMappings[$form_number] ?? null; // Return null if form number is not found
    }
}
