<?php

namespace App\Rules;

use Illuminate\Contracts\Validation\Rule;
use App\Models\ManagerDashboard\Exams\StudentCommittees\StudentCommittee;

class UniqueCommitteeLocation implements Rule
{
    protected $schoolId;
    protected $semester;
    protected $committeeId;

    public function __construct($school, $committee)
    {
        $this->schoolId = $school->id;
        $this->semester = $committee->semester_id;
        $this->committeeId = $committee->id;
    }

    public function passes($attribute, $value)
    {

        $query = StudentCommittee::where('school_id', $this->schoolId)
            ->where('semester_id', $this->semester)
            ->where('location', $value);

        if ($this->committeeId) {
            $query->where('id', '!=', $this->committeeId);
        }

        return !$query->exists();
    }

    public function message()
    {
        return 'تم تعيين هذا المقر بالفعل إلى لجنة أخرى في نفس الفصل الدراسي والمدرسة.';
    }
}
