<?php

namespace App\Rules;

use App\Helpers\Helper;
use Carbon\Carbon;
use Closure;
use Illuminate\Contracts\Validation\ValidationRule;

class DateWithinSemester implements ValidationRule
{
    protected $startDate;
    protected $endDate;
    protected $dateType;


    public function __construct(string $dateType = 'coptic')
    {
        $this->dateType = $dateType;
        $semester = Helper::getCurrentSchoolSemester();
        $this->startDate = Carbon::createFromFormat('d/m/Y', $semester->start_date);
        $this->endDate = Carbon::createFromFormat('d/m/Y', $semester->end_date);
    }


    /**
     * Run the validation rule.
     *
     * @param  \Closure(string): \Illuminate\Translation\PotentiallyTranslatedString  $fail
     */
    public function validate(string $attribute, mixed $value, Closure $fail): void
    {

        if ($value) {

            if ($this->dateType === 'hijri') {
                $value = Helper::getCoptic($value);
            }

            try {
                // Parse the date into a Carbon object
                $date = Carbon::createFromFormat('d/m/Y', $value);
            } catch (\Exception $e) {
                $fail('التاريخ غير صالح.');
                return;
            }

            // Check if the date is within the semester's range
            if (!$date->between($this->startDate, $this->endDate)) {
                $fail('التاريخ يجب أن يكون ضمن الفصل الدراسي الحالي.');
            }
        }
    }
}
