<?php
namespace App\Providers;

use App\Factories\Namozeg132Factory;
use App\Factories\Namozeg141Factory;
use App\Factories\Namozeg142Factory;
use App\Factories\Namozeg143Factory;
use App\Factories\Namozeg145Factory;
use App\Factories\Namozeg146Factory;
use App\Factories\Namozeg147Factory;
use App\Factories\Namozeg149Factory;
use App\Factories\Namozeg151Factory;
use App\Factories\Namozeg157Factory;
use App\Factories\Namozeg160Factory;
use App\Factories\Namozeg161Factory;
use App\Factories\Namozeg228Factory;
use App\Http\Requests\ManagerDashboard\Namazeg\Violations\DestructionProceedRequest;
use App\Http\Requests\ManagerDashboard\Namazeg\Violations\NamazegDepartmentProceduresFormRequest;
use App\Http\Requests\ManagerDashboard\Namazeg\Violations\NamazegFatherNotifyRequest;
use App\Http\Requests\ManagerDashboard\Namazeg\Violations\NamazegFatherNotiyStudentMoveRequest;
use App\Http\Requests\ManagerDashboard\Namazeg\Violations\NamazegGuidanceCommitteeMeetingRequest;
use App\Http\Requests\ManagerDashboard\Namazeg\Violations\NamazegIncidentProceedRequest;
use App\Http\Requests\ManagerDashboard\Namazeg\Violations\NamazegMaintenanceDestructionStudentRequest;
use App\Http\Requests\ManagerDashboard\Namazeg\Violations\NamazegMinusStudentDescionRequest;
use App\Http\Requests\ManagerDashboard\Namazeg\Violations\NamazegRedirectGuidanceRequest;
use App\Http\Requests\ManagerDashboard\Namazeg\Violations\NamazegSafetyCallRequest;
use App\Http\Requests\ManagerDashboard\Namazeg\Violations\NamazegViolationAccedentProceedRequest;
use App\Http\Requests\ManagerDashboard\Namazeg\Violations\NamazegViolationInvitaionLetterRequest;
use App\Http\Requests\ManagerDashboard\Namazeg\Violations\ViolationProceedRequest;
use App\Models\ManagerDashboard\Namazeg\Violations\NamazegViolationInvitaionLetter;
use App\Models\ManagerDashboard\Violations\ViolationStudentPunishment;
use App\Models\ManagerDashboard\Violations\ViolationStudentTitle;

class NamozegFactoryProvider
{
    // protected $handlers = [
    //     "143" => Namozeg143Factory::class,
       
    // ];
    protected $handlers = [
        "143" => [Namozeg143Factory::class, ViolationProceedRequest::class],// محضر مخالفة سلوكية
        "157" => [Namozeg157Factory::class, DestructionProceedRequest::class],// فمحضر اتلا
        "228" => [Namozeg228Factory::class, NamazegDepartmentProceduresFormRequest::class],// نموذج إجراءات إدارة التعليم (إشعار ولي الأمر)
        "142" => [Namozeg142Factory::class, NamazegIncidentProceedRequest::class],//   محضر ضبط الواقعة
        "149" => [Namozeg149Factory::class, NamazegMinusStudentDescionRequest::class],//   اشعار حسم
        "151" => [Namozeg151Factory::class, NamazegFatherNotiyStudentMoveRequest::class],//   نموذج إشعار ولي الأمر بنقل الطالب من المدرسة
        "132" => [Namozeg132Factory::class, NamazegSafetyCallRequest::class],//   نموذج استمارة استدعاء جهة أمنية
        "161" => [Namozeg161Factory::class, NamazegGuidanceCommitteeMeetingRequest::class],//   نموذج محضر اجتماع لجنة التوجيه الطلابي بالمدرسة
        "160" => [Namozeg160Factory::class, NamazegRedirectGuidanceRequest::class],//   نموذج إحالة لإدارة قسم التوجيه الطلاب
        "147" => [Namozeg147Factory::class, NamazegFatherNotifyRequest::class],//   نموذج إشعار ولي أمر الطالب 
        "141" => [Namozeg141Factory::class, NamazegMaintenanceDestructionStudentRequest::class],//   محضر اصلاح ما اتلفة الطالب
        "145" => [Namozeg145Factory::class, NamazegViolationAccedentProceedRequest::class],//   محضر اثبات واقعه
        "146" => [Namozeg146Factory::class, NamazegViolationInvitaionLetterRequest::class],//   خطاب دعوة

    ];

    public function store($school_id,$violation_student_punishment )
    {
        $form_number = $violation_student_punishment->namozeg->form_number;
        if (isset($this->handlers[$form_number])) {
            [$handlerClass, $requestClass] = $this->handlers[$form_number];

            $handler = new $handlerClass();
            $customRequest = app($requestClass);
            $customRequest->validateResolved();
            return  $handler->store($school_id,$violation_student_punishment, $customRequest);
        }
        
        return response()->json(['error' => 'Form not supported'], 400);
    }


    public function update($namozeg_version_id,$violation_student_punishment )
    {
        $form_number = $violation_student_punishment->namozeg->form_number;
        if (isset($this->handlers[$form_number])) {
            [$handlerClass, $requestClass] = $this->handlers[$form_number];

            $handler = new $handlerClass();
            $customRequest = app($requestClass);
            $customRequest->validateResolved();
            return $handler->update($namozeg_version_id, $customRequest);
        }
        return response()->json(['error' => 'Form not supported'], 400);
    }


    public function get($form_number, $school, $request, $namozeg_version )
    {
        if (isset($this->handlers[$form_number])) {
            [$handlerClass, $requestClass] = $this->handlers[$form_number];
            $handler = new $handlerClass();
            return $handler->handle($school, $request, $namozeg_version);
        }
        return response()->json(['error' => 'Form not supported'], 400);
    }


    public static function update_status_violationStudentTitle($violation_student_title_id){
        $vioaltion_student_punishments = ViolationStudentPunishment::where('violation_student_title_id', $violation_student_title_id)->get();
        $vioaltion_student_punishments_all = $vioaltion_student_punishments->count();
        $vioaltion_student_punishments_done = $vioaltion_student_punishments->where('status', 'done')->count();
        if ($vioaltion_student_punishments_all == $vioaltion_student_punishments_done) {
            ViolationStudentTitle::where('id', $violation_student_title_id)->update(['status' => 'done']);
        }
    } 
}
