<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\SoftDeletes;

class ViolationTitle extends Model
{ 
    use HasFactory,SoftDeletes;

    protected $table='violation_titles';
    protected $guarded=[];


    public function punishments(){
        return $this->hasMany(ViolationPunishment::class)->with('namzeg', 'related_punishments');
    }
    public function violation_name(){
        return $this->belongsTo(ViolationName::class,'name');
    }
}
