<?php

namespace App\Models\ManagerDashboard\Violations;

use App\Models\ManagerDashboard\Namazeg\NamazegVersion;
use App\Models\Namazeg;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\SoftDeletes;

class ViolationStudentPunishment extends Model
{
    use HasFactory,SoftDeletes;

    protected $table = 'violation_student_punishments';
    protected $guarded = [];

    public function namozegVersion()
    {
        return $this->belongsTo(NamazegVersion::class, 'namazeg_version_id')->with('namozeg');
    }

    public function namozeg()
    {
        return $this->belongsTo(Namazeg::class, 'punishment_id');
    }

    public function VStudentTitle()
    {
        return $this->belongsTo(ViolationStudentTitle::class, 'violation_student_title_id')->with('ViolationStudent');
    }
}
