<?php

namespace App\Models\ManagerDashboard\Violations;

use App\Models\AdminDashboard\School\Student;
use App\Models\GradeViolation;
use App\Models\ManagerDashboard\Namazeg\NamazegVersion;
use App\Models\Violation;
use App\Models\ViolationTitle;
use App\Models\ViolationType;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\SoftDeletes;

class ViolationStudent extends Model
{
    use HasFactory,SoftDeletes;

    protected $table = 'violation_students';
    protected $guarded = [];

    public function namozegVersion()
    {
        return $this->belongsTo(NamazegVersion::class, 'namazeg_version_id');
    }

    public function punishments()
    {
        return $this->hasMany(ViolationStudentPunishment::class, 'violation_student_id');
    }

    public function student()
    {
        return $this->belongsTo(Student::class, 'student_id')->with('schoolClass');
    }

    public function type()
    {
        return $this->belongsTo(ViolationType::class, 'violation_type_id');
    }

    public function category()
    {
        return $this->belongsTo(Violation::class, 'violation_category_id');
    }

    public function violationGrade()
    {
        return $this->belongsTo(GradeViolation::class, 'violation_grade_id');
    }

    public function violationCategoryCount($violation_category_id)
    {
        return ViolationStudent::where('violation_category_id', $violation_category_id)->where('student_id', $this->student_id)->count();
    }

    public function violation_titles()
    {
        return $this->hasMany(ViolationStudentTitle::class, 'violation_student_id')->with('title', 'punishments');
    }

    public function pending_violations($student_id)
    {
        $violation_student_ids  = ViolationStudent::where('student_id', $student_id)->pluck('id')->toArray();
        return ViolationStudentTitle::whereIn('violation_student_id', $violation_student_ids)
            ->where('created_at', '<=', Carbon::now()->subWeek())
            ->where('status',  'started')->count();
    }
}
