<?php

namespace App\Models\ManagerDashboard\TeamAndCommitteeMeetings;

use App\Models\AdminDashboard\School\School;
use App\Models\ManagerDashboard\Assignments\AssignmentTeam;
use App\Models\ManagerDashboard\Assignments\TaskCommitteeTeam;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Relations\MorphMany;

class Team extends Model
{
    use SoftDeletes;
    protected $table='teams';
    protected $guarded = [];

    public function meetings() {
        return $this->hasMany(Meeting::class,'model_id')->where('model_type','teams');
    }

    public function members() {
        return $this->hasMany(TeamMember::class,'team_id');
    }

    public function school() {
        return $this->belongsTo(School::class,'school_id');
    }

    public function assignment() {
        return $this->hasOne(AssignmentTeam::class);
    }


    public function tasks()
    {
        return $this->morphMany(TaskCommitteeTeam::class, 'taskable');
    }
}
