<?php

namespace App\Models\ManagerDashboard\TeamAndCommitteeMeetings;

use App\Helpers\Helper;
use App\Models\AdminDashboard\School\SchoolSemester;
use App\Models\ManagerDashboard\Namazeg\NamazegVersion;
use App\Traits\CascadeSoftDeletes;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Casts\Attribute;
use Illuminate\Database\Eloquent\SoftDeletes;

class Meeting extends Model
{
    use SoftDeletes,CascadeSoftDeletes;
    protected $table='meetings';
    protected $guarded = [];
    protected $cascadeDeletes = ['meetingScheduals','meetingRecommendations'];
    protected $appends = ['serial_number','semester_name','date_options','created_at_options'];

    protected $useAccessors = true;

    public function disableAccessors()
    {
        $this->useAccessors = false;
        return $this;
    }

    public function enableAccessors()
    {
        $this->useAccessors = true;
        return $this;
    }

    public function getDateOptionsAttribute()
    {
        // return $this->date_type;
        $date_type = $this->date_type=="هجرى"?'hijri':'coptic';
        return Helper::getDateOptions($this->date, 'coptic');
    }

    public function getCreatedAtOptionsAttribute()
    {
        return Helper::getDateOptions($this->created_at, 'coptic');
    }  
    
    public function semester()
    {
        return $this->belongsTo(SchoolSemester::class, 'semester_id');
    }

    public function getSemesterNameAttribute()
    {
        return $this->semester->name;
    }  

    protected function meetingType(): Attribute
    {
        return Attribute::make(
            get: fn ($value) => $this->useAccessors
                ? trans('api.'. $value)
                : $value
        );
    }

    protected function dateType(): Attribute
    {
        return Attribute::make(
            get: fn (string $value) => trans('api.'. $value),
        );
    }

    protected function meetingStatus(): Attribute
    {
        return Attribute::make(
            get: fn (string $value) => trans('api.'. $value),
        );
    }

    protected function createdAt(): Attribute
    {
        return Attribute::make(
            get: fn ($value) => $this->useAccessors
                ? \Carbon\Carbon::parse($value)->format('d/m/Y')
                : $value
        );
    }

    public function meetingScheduals() {
        return $this->hasMany(MeetingSchedual::class,'meeting_id');
    }

    public function meetingRecommendations() {
        return $this->hasMany(MeetingRecommendation::class,'meeting_id');
    }

    public function meetingExcuteedRecommendations() {
        return $this->hasMany(MeetingRecommendation::class,'meeting_id')->where('recommendation_status','executed');
    }

    public function meetingNotExcuteedRecommendations() {
        return $this->hasMany(MeetingRecommendation::class,'meeting_id')->where('recommendation_status','not_executed');
    }

    public function namozegVersion(){
        return $this->belongsTo(NamazegVersion::class,'namazeg_version_id');
    }

    public function getSerialNumberAttribute()
    {
        return $this->namozegVersion()->first()->serial_number ?? null;
    }

    public function members()
    {
        if($this->model_type == 'committees') {
            return $this->hasMany(CommitteeMember::class, 'committee_id', 'model_id');
        } else {
            return $this->hasMany(TeamMember::class, 'team_id', 'model_id');
        }
    }
    public function committe()
    {
        return $this->belongsTo(Committee::class, 'model_id');
    }

    public function team()
    {
        return $this->belongsTo(Team::class, 'model_id');
    }

}
