<?php

namespace App\Models\ManagerDashboard\TeamAndCommitteeMeetings;

use App\Models\AdminDashboard\School\School;
use App\Models\ManagerDashboard\Assignments\AssignmentCommittee;
use App\Models\ManagerDashboard\Assignments\TaskCommitteeTeam;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Committee extends Model
{
    use SoftDeletes;
    protected $table='committees';
    protected $guarded = [];

    public function meetings() {
        return $this->hasMany(Meeting::class,'model_id')->where('model_type','committees');
    }

    public function members() {
        return $this->hasMany(CommitteeMember::class,'committee_id');
    }

    public function school() {
        return $this->belongsTo(School::class,'school_id');
    }


    public function assignment() {
        return $this->hasOne(AssignmentCommittee::class, 'committee_id');
    }
    

    public function tasks()
    {
        return $this->morphMany(TaskCommitteeTeam::class, 'taskable');
    }

}
