<?php

namespace App\Models\ManagerDashboard;

use App\Models\AdminDashboard\School\School;
use App\Models\AdminDashboard\School\SchoolClass;
use App\Models\AdminDashboard\School\SchoolSemester;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class TeacherSchedule extends Model
{
    use HasFactory;

    protected $table = 'teacher_schedules';

    protected $guarded = [];


    public function semester(){
        return $this->belongsTo(SchoolSemester::class,'semester_id');
    }
    public function class(){
        return $this->belongsTo(SchoolClass::class,'school_class_id')->with('className');
    }
    
    public function schedule_data()
    {
        return $this->hasMany(TeacherScheduleData::class, 'teacher_schedule_id');
    }

    public function school(){
        return $this->belongsTo(School::class,);
    }
}
