<?php

namespace App\Models\ManagerDashboard\Tables\WaitingPeriodsSchedule;

use App\Models\AdminDashboard\School\Period ;
use App\Models\AdminDashboard\School\SchoolClass;
use App\Models\AdminDashboard\School\SchoolEmployee;
use App\Models\AdminDashboard\School\Subject;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class WaitingPeriodsScheduleData extends Model
{
    use HasFactory;

    protected $table = 'waiting_periods_schedule_data';
    protected $guarded = [];

    
    public function period()
    {
        return $this->belongsTo(Period::class);
    }
    
    public function alternative_employee()
    {
        return $this->belongsTo(SchoolEmployee::class, 'school_employee_id');
    }

    public function parentSchedule()
    {
        return $this->belongsTo(WaitingPeriodsSchedule::class, 'schedule_id');
    }

    public function subject()
    {
        return $this->belongsTo(Subject::class, 'subject_id');
    }

    public function class(){
        return $this->belongsTo(SchoolClass::class,'school_class_id');
    }

    public function employee(){
        return $this->belongsTo(SchoolEmployee::class, 'school_employee_id');
    }

}
