<?php

namespace App\Models\ManagerDashboard;

use App\Models\AdminDashboard\School\SchoolEmployee;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

use App\Models\Day;
use App\Models\Floor;

class Supervisor extends Model
{
    use HasFactory;

    protected $table = 'supervisors';
    protected $guarded = [];

    public function day_name()
    {
        return $this->belongsTo(Day::class, 'day_id');
    }
    public function floor_name()
    {
        return $this->belongsTo(Floor::class, 'floor_id');
    }

    public function employee()
    {
        return $this->belongsTo(SchoolEmployee::class, 'school_employee_id');
    }

}
