<?php

namespace App\Models\ManagerDashboard;

use App\Models\AdminDashboard\School\SchoolSemester;
use App\Models\ManagerDashboard\Namazeg\NamazegVersion;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class SupervisionSchedul extends Model
{
    use HasFactory,SoftDeletes;

    protected $table = 'supervision_schedules';

    protected $guarded = [];


    public function semester(){
        return $this->belongsTo(SchoolSemester::class,'semester_id');
    }
    
    public function supervisors()
    {
        return $this->hasMany(Supervisor::class, 'supervision_schedule_id')->where('type','day');
    }
    public function follow_supervisors()
    {
        return $this->hasMany(Supervisor::class, 'supervision_schedule_id')->where('type','follow');
    }

    public function namozegVersion()
    {
        return $this->belongsTo(NamazegVersion::class, 'namazeg_version_id')->with('namozeg');
    }

}
