<?php

namespace App\Models\ManagerDashboard\OfficialSpeeches;

use App\Models\AdminDashboard\School\SchoolEmployee;
use App\Models\ManagerDashboard\Namazeg\NamazegVersion;
use App\Models\ManagerDashboard\OfficialSpeeches\AlertNote;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Alert extends Model
{
    use HasFactory,SoftDeletes;

    protected $table = 'alerts';

    protected $guarded = []; 

    public function notes()
    {
        return $this->hasMany(AlertNote::class,'alert_id');
    }

    public function employee()
    {
        return $this->belongsTo(SchoolEmployee::class,'alert_direct_to');
    }

    public function namozegVersion()
    {
        return $this->belongsTo(NamazegVersion::class, 'namazeg_version_id')->with('namozeg');
    }
   
}
