<?php

namespace App\Models\ManagerDashboard\Namazeg\Violations;

use App\Models\AdminDashboard\School\Student;
use App\Models\GradeViolation;
use App\Models\ManagerDashboard\Namazeg\NamazegVersion;
use App\Models\Violation;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class StudentViolationDegrees  extends Model
{
    //درجات الحسم للطلاب
    use HasFactory,SoftDeletes;
    protected $table= "student_violation_degrees";
    protected $guarded = [];


    public function namozegVersion()
    {
        return $this->belongsTo(NamazegVersion::class, 'namazeg_version_id')->with('namozeg');
    }

    public function student(){
        return $this->belongsTo(Student::class, 'student_id');
    }

    public function violation_category(){
        return $this->belongsTo(Violation::class, 'violation_category_id');
    }
    public function violation_grade(){
        return $this->belongsTo(GradeViolation::class, 'violation_grade_id');
    }
    

    
}
