<?php

namespace App\Models\ManagerDashboard\Namazeg\Violations;

use App\Models\ManagerDashboard\Namazeg\NamazegVersion;
use App\Models\ManagerDashboard\Violations\ViolationStudentPunishment;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class NamazegDestructionProceed  extends Model
{
    //157 محضر  اتلاف
    use HasFactory,SoftDeletes;
    protected $table= "namazeg_destruction_proceeds";
    protected $guarded = [];

    public function setDetailsAttribute($value)
    {
        $this->attributes['details'] = json_encode($value, JSON_UNESCAPED_UNICODE);
    }

    public function getDetailsAttribute($value)
    {
        return json_decode($value, true);
    }

    public function namozegVersion()
    {
        return $this->belongsTo(NamazegVersion::class, 'namazeg_version_id')->with('namozeg');
    }

    public function VStudentPunishment(){
        return $this->belongsTo(ViolationStudentPunishment::class, 'v_student_punishment_id')->with('VStudentTitle');
    }

    
}
