<?php

namespace App\Models\ManagerDashboard\Namazeg\Violations;

use App\Helpers\Helper;
use App\Models\ManagerDashboard\Namazeg\NamazegVersion;
use App\Models\ManagerDashboard\Violations\ViolationStudentPunishment;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class NamazegDepartmentProceduresForm extends Model
{
    //228 نموذج إجراءات إدارة التعليم (إشعار ولي الأمر) 
    use HasFactory,SoftDeletes;
    protected $table = "namazeg_department_procedures_forms";
    protected $guarded = [];
    public function namozegVersion()
    {
        return $this->belongsTo(NamazegVersion::class, 'namazeg_version_id')->with('namozeg');
    }

    public function setOptionsAttribute($value)
    {
        $this->attributes['options'] = json_encode(array_map('intval', $value), JSON_UNESCAPED_UNICODE);
    }
    public function getOptionsAttribute($value)
    {
        return NamazegProceduresFormOption::whereIn('id', json_decode($value, true))
        ->select('id', 'name')
        ->get();
    }


    public function degress()
    {
        return $this->belongsTo(StudentViolationDegrees::class, 'namazeg_version_id', 'namazeg_version_id')->with('namozegVersion');
    }

    public function VStudentPunishment()
    {
        return $this->belongsTo(ViolationStudentPunishment::class, 'v_student_punishment_id')->with('VStudentTitle');
    }
}
