<?php

namespace App\Models\ManagerDashboard\Namazeg;

use App\Helpers\Helper;
use App\Models\AdminDashboard\School\SchoolSemester;
use App\Models\Week;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class NamazegManagerPlane extends Model
{
    //131 خطة المديرة
    use HasFactory,SoftDeletes;
    protected $guarded = [];
    public function namozegVersion()
    {
        return $this->belongsTo(NamazegVersion::class, 'namazeg_version_id')->with('namozeg');
    }
    public function plane_details()
    {
        return $this->hasMany(NamazegManagerPlaneDetails::class, 'namazeg_manager_plane_id');
    }
    public function week()
    {
        return $this->belongsTo(Week::class);
    }
    public function semester()
    {
        return $this->belongsTo(SchoolSemester::class);
    }
    
    
}
