<?php

namespace App\Models\ManagerDashboard\Namazeg;

use App\Models\AdminDashboard\School\SchoolEmployee;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class NamazegAbsenceDescionConfirm extends Model
{
    //170 قرار حسم غياب
    use HasFactory , SoftDeletes;
    protected $guarded = [];
    public function namozegVersion()
    {
        return $this->belongsTo(NamazegVersion::class, 'namazeg_version_id')->with('namozeg');
    }
    public function employee()
    {
        return $this->belongsTo(SchoolEmployee::class, 'employee_id');
    }

    public function descion_action(){
        return $this->hasOne(AbsenceQuestioningAction::class, 'absence_descion_confirm_id');
    }
    
    public function getHasActionAttribute(){
        return $this->descion_action?true:false;
    }

    
}
