<?php

namespace App\Models\ManagerDashboard\Assignments;

use App\Models\AdminDashboard\School\SchoolEmployee;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class GeneralAssignmentEmployee extends Model
{
    use HasFactory; use SoftDeletes;
    
    protected $table = 'assignment_general_employees';

    protected $guarded = [];
    

    public function employee()
    {
        return $this->belongsTo(SchoolEmployee::class,'employee_id');
    }

    public function generalAssignment()
    {
        return $this->belongsTo(GeneralAssignment::class,'general_assignment_id');
    }
    
}
