<?php

namespace App\Models\ManagerDashboard\Assignments;

use App\Models\AdminDashboard\School\SchoolEmployee;
use App\Models\ManagerDashboard\Namazeg\NamazegVersion;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class GeneralAssignment extends Model
{
    use HasFactory; use SoftDeletes;

    protected $table = 'assignments_general';

    protected $guarded = [];

 
    public function generalAssignmentEmployees()
    {
        return $this->hasMany(GeneralAssignmentEmployee::class, 'general_assignment_id');
    }
    
    public function duration()
    {
        return $this->belongsTo(DurationAssignment::class,'duration_id');
    }

    public function namozegVersion()
    {
        return $this->belongsTo(NamazegVersion::class, 'namazeg_version_id')->with('namozeg');
    }
    
}
