<?php

namespace App\Models\ManagerDashboard\Assignments;

use App\Models\ManagerDashboard\Namazeg\NamazegVersion;
use App\Models\ManagerDashboard\TeamAndCommitteeMeetings\Team;
use App\Models\ManagerDashboard\TeamAndCommitteeMeetings\TeamMember;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class AssignmentTeam extends Model
{
    use HasFactory; use SoftDeletes;
    
    protected $table = 'assignment_teams';

    protected $guarded=[];

    public function team()
    {
        return $this->belongsTo(Team::class);
    }

    public function namozegVersion()
    {
        return $this->belongsTo(NamazegVersion::class, 'namazeg_version_id')->with('namozeg');
    }

    public function teamMembers()
    {
        return $this->hasMany(TeamMember::class,'assignment_team_id');
    }
}
